// Copyright Epic Games, Inc. All Rights Reserved.

#include "ArkSourceControl.h"

#define LOCTEXT_NAMESPACE "FArkSourceControlModule"

FArkSourceControlModule& FArkSourceControlModule::Get()
{
	return FModuleManager::LoadModuleChecked<FArkSourceControlModule>("ArkSourceControl"); 
}

void FArkSourceControlModule::StartupModule()
{
	settings.load_settings();
	IModularFeatures::Get().RegisterModularFeature("SourceControl", &provider);

}

void FArkSourceControlModule::ShutdownModule()
{
	provider.Close();
	IModularFeatures::Get().UnregisterModularFeature("SourceControl", &provider);
}

#undef LOCTEXT_NAMESPACE
	
IMPLEMENT_MODULE(FArkSourceControlModule, ArkSourceControl)