﻿#include "FArkSourceControlChangelistState.h"

#include "FArkSourceControlChangelist.h"
#include "Ark_Plugin.h"
#include "ArkSourceControl.h"

void FArkSourceControlChangelistState::update(const Ark_Plugin_Ws_Cl& plugin_ws_cl) {
	changelist.ws_cl_id = plugin_ws_cl.ws_cl_id;
	changelist.cl_id = plugin_ws_cl.cl_id;
	changelist.is_default = plugin_ws_cl.is_default != 0;

	comment = ARK_PLUGIN_STRING_TO_FSTRING(plugin_ws_cl.comment);

	files_states.Reset();
	files_states.Reserve(plugin_ws_cl.relative_paths.count);

	TArray<FString> added_file_relative_paths;

	auto& provider = FArkSourceControlModule::Get().provider;

	for (int32 relative_path_index = 0; relative_path_index != plugin_ws_cl.relative_paths.count; ++relative_path_index) {
		Ark_Plugin_String* relative_path_ptr = plugin_ws_cl.relative_paths.data + relative_path_index;
		FString relative_path = ARK_PLUGIN_STRING_TO_FSTRING((*relative_path_ptr));
		bool out_added;
		FSourceControlStateRef* file_state_ref = provider.get_file_state_ref(relative_path, &out_added);
		files_states.Add(*file_state_ref);
		if (out_added) {
			added_file_relative_paths.Add(relative_path);
		}
	}

	if (added_file_relative_paths.Num() > 0) {
		provider.force_update_relative_paths(added_file_relative_paths);
	}
}

FSourceControlChangelistRef FArkSourceControlChangelistState::GetChangelist() const
{
	FSourceControlChangelistRef changelist_copy = MakeShareable( new FArkSourceControlChangelist(changelist));
	return StaticCastSharedRef<ISourceControlChangelist>(changelist_copy);
}
